<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

$sql = "SELECT p.*, a.nama 
        FROM pinjaman p
        JOIN anggota a ON p.anggota_id = a.id
        ORDER BY p.tanggal DESC";
$result = $db->query($sql);
?>

<h2>Laporan Pinjaman</h2>

<table class="table">
    <thead>
        <tr>
            <th>No</th>
            <th>Anggota</th>
            <th>Jumlah</th>
            <th>Sisa</th>
            <th>Status</th>
            <th>Tanggal</th>
        </tr>
    </thead>
    <tbody>
        <?php $no=1; while($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= $no++; ?></td>
            <td><?= $row['nama']; ?></td>
            <td>Rp <?= number_format($row['jumlah'],0,',','.'); ?></td>
            <td>Rp <?= number_format($row['sisa'],0,',','.'); ?></td>
            <td>
                <?php
                if($row['status']=='lunas') echo '<span style="color:green">Lunas</span>';
                elseif($row['status']=='disetujui') echo '<span style="color:blue">Berjalan</span>';
                elseif($row['status']=='menunggu') echo '<span style="color:orange">Menunggu</span>';
                else echo '<span style="color:red">Ditolak</span>';
                ?>
            </td>
            <td><?= date('d-m-Y', strtotime($row['tanggal'])); ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<?php require_once '../../templates/footer.php'; ?>
